# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
Solving this was confusing though.

# Approach
<!-- Describe your approach to solving the problem. -->
As all servings are in multiple of 25ml, lets work in multiple of 25 :- if A has 50ml  it means 2 serves ; if A has 54ml then 3 serves ( 25 + 25 + 4)


- serve( A, B ) means the result probability for Aml of soup A and Bml of soup B.
- - serve( A- 4, B ) means that we take the first operation : Serve 100ml of soup A ( left A = A - 25 * 4 ) and 0 ml of soup B ( left B = B - 25 * 0 ). f(a-3,b-1), f(a-2,b-2), f(a-1,b-3) are other 3 operations.
- - serve( A - 3, B - 1) means that we take the second operation : Serve 75ml of soup A ( left A = A - 25 * 3 ) and 25 ml of soup B ( left B = B - 25 * 1 )
- - serve( A - 2, B - 2) means that we take the third operation : Serve 50ml of soup A ( left A = A - 25 * 2 ) and 50 ml of soup B ( left B = B - 25 * 2 )
- - serve( A - 1, B - 3) means that we take the fourth operation : Serve 25ml of soup A ( left A = A - 25 * 1 ) and 75 ml of soup B ( left B = B - 25 * 3 )

" Note that we do not have an operation where all 100 ml's of soup B are used first. "
It can be easily visualised that A will get emptied faster than B. And when n gets bigger, we have lesser chance to run out of B first.

When n = 4800, the result = 1.0  ( 0.999994994426 )
When n = 4801, the result = 1.0  ( 0.999995382315 )
Answers within 10^-5 of the true value will be accepted as correct.
So if n >= 4800, simply return 1 


Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)


# Complexity
- Time complexity : $$O(1)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O(1)$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public double soupServings(int n) {
        return n >= 4800 ? 1.0 : serve( (n+24)/25, (n+24)/25 );   // here ( n + 24)/25 is same as Math.ceil(n/25) ; but due to data type issue i have to use this
    }

    double[][] m = new double[ 4800/25][ 4800/25];

    double serve( int A, int B){
        if( A <= 0 && B <= 0){     // it means soup A and B get emptied at the same time
            return 0.5;            // return probability of 0.5 ( half of 1.0 )

        }
        if( A <= 0){
            return 1.0;
        }
        if( B <= 0 ){
            return 0.0;
        }
        if( m[A][B] > 0 ){
            return m[A][B];
        }
        return m[A][B] = 0.25 * ( serve( A - 4, B - 0) + serve( A - 3, B - 1) + serve( A - 2, B - 2) + serve( A - 1, B - 3) );
    }
}
```